/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.expression.condition;

import java.util.ArrayList;
import org.h14199.engine.Database;
import org.h14199.engine.Session;
import org.h14199.expression.Expression;
import org.h14199.expression.ExpressionColumn;
import org.h14199.expression.ExpressionVisitor;
import org.h14199.expression.Parameter;
import org.h14199.expression.ValueExpression;
import org.h14199.expression.aggregate.Aggregate;
import org.h14199.expression.aggregate.AggregateType;
import org.h14199.expression.condition.Condition;
import org.h14199.expression.condition.ConditionIn;
import org.h14199.index.IndexCondition;
import org.h14199.message.DbException;
import org.h14199.table.Column;
import org.h14199.table.ColumnResolver;
import org.h14199.table.TableFilter;
import org.h14199.value.TypeInfo;
import org.h14199.value.Value;
import org.h14199.value.ValueBoolean;
import org.h14199.value.ValueGeometry;
import org.h14199.value.ValueNull;

public class Comparison
extends Condition {
    public static final int NULL_SAFE = 16;
    public static final int EQUAL = 0;
    public static final int EQUAL_NULL_SAFE = 16;
    public static final int BIGGER_EQUAL = 1;
    public static final int BIGGER = 2;
    public static final int SMALLER_EQUAL = 3;
    public static final int SMALLER = 4;
    public static final int NOT_EQUAL = 5;
    public static final int NOT_EQUAL_NULL_SAFE = 21;
    public static final int IS_NULL = 6;
    public static final int IS_NOT_NULL = 7;
    public static final int FALSE = 8;
    public static final int IN_LIST = 9;
    public static final int IN_QUERY = 10;
    public static final int SPATIAL_INTERSECTS = 11;
    private final Database database;
    private int compareType;
    private Expression left;
    private Expression right;

    public Comparison(Session session, int n, Expression expression, Expression expression2) {
        this.database = session.getDatabase();
        this.left = expression;
        this.right = expression2;
        this.compareType = n;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        boolean bl2 = false;
        stringBuilder.append('(');
        switch (this.compareType) {
            case 6: {
                this.left.getSQL(stringBuilder, bl).append(" IS NULL");
                break;
            }
            case 7: {
                this.left.getSQL(stringBuilder, bl).append(" IS NOT NULL");
                break;
            }
            case 11: {
                stringBuilder.append("INTERSECTS(");
                this.left.getSQL(stringBuilder, bl).append(", ");
                this.right.getSQL(stringBuilder, bl).append(')');
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.right instanceof Aggregate && ((Aggregate)this.right).getAggregateType() == AggregateType.ANY) {
                    bl2 = true;
                }
            }
            default: {
                this.left.getSQL(stringBuilder, bl).append(' ').append(Comparison.getCompareOperator(this.compareType)).append(' ');
                if (bl2) {
                    stringBuilder.append('(');
                }
                this.right.getSQL(stringBuilder, bl);
                if (!bl2) break;
                stringBuilder.append(')');
            }
        }
        return stringBuilder.append(')');
    }

    static String getCompareOperator(int n) {
        switch (n) {
            case 0: {
                return "=";
            }
            case 16: {
                return "IS";
            }
            case 1: {
                return ">=";
            }
            case 2: {
                return ">";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return "<";
            }
            case 5: {
                return "<>";
            }
            case 21: {
                return "IS NOT";
            }
            case 11: {
                return "&&";
            }
        }
        throw DbException.throwInternalError("compareType=" + n);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            Object object;
            this.right = this.right.optimize(session);
            if (this.right.getType().getValueType() == 17 && this.left.getType().getValueType() != 17) {
                throw DbException.get(90110);
            }
            if (this.right instanceof ExpressionColumn && (this.left.isConstant() || this.left instanceof Parameter)) {
                object = this.left;
                this.left = this.right;
                this.right = object;
                this.compareType = this.getReversedCompareType(this.compareType);
            }
            if (this.left instanceof ExpressionColumn) {
                if (this.right.isConstant()) {
                    TypeInfo typeInfo;
                    object = this.right.getValue(session);
                    if (object == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
                        return ValueExpression.getNull();
                    }
                    TypeInfo typeInfo2 = this.left.getType();
                    TypeInfo typeInfo3 = ((Value)object).getType();
                    int n = typeInfo3.getValueType();
                    if (n != typeInfo2.getValueType() && n != (typeInfo = Value.getHigherType(typeInfo2, typeInfo3)).getValueType()) {
                        Column column = ((ExpressionColumn)this.left).getColumn();
                        this.right = ValueExpression.get(((Value)object).convertTo(typeInfo, session.getDatabase().getMode(), column));
                    }
                } else if (this.right instanceof Parameter) {
                    ((Parameter)this.right).setColumn(((ExpressionColumn)this.left).getColumn());
                }
            }
        }
        if (this.compareType == 6 || this.compareType == 7) {
            if (this.left.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        } else {
            if (this.left == null || this.right == null) {
                DbException.throwInternalError(this.left + " " + this.right);
            }
            if ((this.left == ValueExpression.getNull() || this.right == ValueExpression.getNull()) && (this.compareType & 0x10) == 0) {
                return ValueExpression.getNull();
            }
            if (this.left.isConstant() && this.right.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
        }
        return this;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (this.right == null) {
            boolean bl;
            switch (this.compareType) {
                case 6: {
                    bl = value == ValueNull.INSTANCE;
                    break;
                }
                case 7: {
                    bl = value != ValueNull.INSTANCE;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("type=" + this.compareType);
                }
            }
            return ValueBoolean.get(bl);
        }
        if (value == ValueNull.INSTANCE && (this.compareType & 0x10) == 0) {
            return ValueNull.INSTANCE;
        }
        return Comparison.compare(this.database, value, this.right.getValue(session), this.compareType);
    }

    static Value compare(Database database, Value value, Value value2, int n) {
        Value value3;
        switch (n) {
            case 0: {
                int n2 = database.compareWithNull(value, value2, true);
                if (n2 == 0) {
                    value3 = ValueBoolean.TRUE;
                    break;
                }
                if (n2 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.FALSE;
                break;
            }
            case 16: {
                value3 = ValueBoolean.get(database.areEqual(value, value2));
                break;
            }
            case 5: {
                int n3 = database.compareWithNull(value, value2, true);
                if (n3 == 0) {
                    value3 = ValueBoolean.FALSE;
                    break;
                }
                if (n3 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.TRUE;
                break;
            }
            case 21: {
                value3 = ValueBoolean.get(!database.areEqual(value, value2));
                break;
            }
            case 1: {
                int n4 = database.compareWithNull(value, value2, false);
                if (n4 >= 0) {
                    value3 = ValueBoolean.TRUE;
                    break;
                }
                if (n4 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.FALSE;
                break;
            }
            case 2: {
                int n5 = database.compareWithNull(value, value2, false);
                if (n5 > 0) {
                    value3 = ValueBoolean.TRUE;
                    break;
                }
                if (n5 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.FALSE;
                break;
            }
            case 3: {
                int n6 = database.compareWithNull(value, value2, false);
                if (n6 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.get(n6 <= 0);
                break;
            }
            case 4: {
                int n7 = database.compareWithNull(value, value2, false);
                if (n7 == Integer.MIN_VALUE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                value3 = ValueBoolean.get(n7 < 0);
                break;
            }
            case 11: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    value3 = ValueNull.INSTANCE;
                    break;
                }
                ValueGeometry valueGeometry = (ValueGeometry)value.convertTo(22);
                ValueGeometry valueGeometry2 = (ValueGeometry)value2.convertTo(22);
                value3 = ValueBoolean.get(valueGeometry.intersectsBoundingBox(valueGeometry2));
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n);
            }
        }
        return value3;
    }

    private int getReversedCompareType(int n) {
        switch (this.compareType) {
            case 0: 
            case 5: 
            case 11: 
            case 16: 
            case 21: {
                return n;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        if (this.compareType == 11) {
            return null;
        }
        int n = this.getNotCompareType();
        return new Comparison(session, n, this.left, this.right);
    }

    private int getNotCompareType() {
        switch (this.compareType) {
            case 0: {
                return 5;
            }
            case 16: {
                return 21;
            }
            case 5: {
                return 0;
            }
            case 21: {
                return 16;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
        }
        throw DbException.throwInternalError("type=" + this.compareType);
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        boolean bl;
        ExpressionVisitor expressionVisitor;
        if (!tableFilter.getTable().isQueryComparable()) {
            return;
        }
        ExpressionColumn expressionColumn = null;
        if (this.left instanceof ExpressionColumn && tableFilter != (expressionColumn = (ExpressionColumn)this.left).getTableFilter()) {
            expressionColumn = null;
        }
        if (this.right == null) {
            if (expressionColumn != null) {
                switch (this.compareType) {
                    case 6: {
                        tableFilter.addIndexCondition(IndexCondition.get(16, expressionColumn, ValueExpression.getNull()));
                    }
                }
            }
            return;
        }
        ExpressionColumn expressionColumn2 = null;
        if (this.right instanceof ExpressionColumn && tableFilter != (expressionColumn2 = (ExpressionColumn)this.right).getTableFilter()) {
            expressionColumn2 = null;
        }
        if (expressionColumn == null && expressionColumn2 == null) {
            return;
        }
        if (expressionColumn != null && expressionColumn2 != null) {
            return;
        }
        if (expressionColumn == null) {
            expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            if (!this.left.isEverything(expressionVisitor)) {
                return;
            }
        } else if (expressionColumn2 == null) {
            expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            if (!this.right.isEverything(expressionVisitor)) {
                return;
            }
        } else {
            return;
        }
        switch (this.compareType) {
            case 5: 
            case 21: {
                bl = false;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 16: {
                bl = true;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.compareType);
            }
        }
        if (bl) {
            if (expressionColumn != null) {
                int n = this.right.getType().getValueType();
                if (expressionColumn.getType().getValueType() == n || n != 14) {
                    tableFilter.addIndexCondition(IndexCondition.get(this.compareType, expressionColumn, this.right));
                }
            } else if (expressionColumn2 != null) {
                int n = this.left.getType().getValueType();
                if (expressionColumn2.getType().getValueType() == n || n != 14) {
                    int n2 = this.getReversedCompareType(this.compareType);
                    tableFilter.addIndexCondition(IndexCondition.get(n2, expressionColumn2, this.left));
                }
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        if (this.right != null) {
            this.right.updateAggregate(session, n);
        }
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (this.compareType == 6 && bl) {
            return;
        }
        super.addFilterConditions(tableFilter, bl);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        if (this.right != null) {
            this.right.mapColumns(columnResolver, n, n2);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && (this.right == null || this.right.isEverything(expressionVisitor));
    }

    @Override
    public int getCost() {
        return this.left.getCost() + (this.right == null ? 0 : this.right.getCost()) + 1;
    }

    Expression getIfEquals(Expression expression) {
        if (this.compareType == 0) {
            String string = expression.getSQL(true);
            if (this.left.getSQL(true).equals(string)) {
                return this.right;
            }
            if (this.right.getSQL(true).equals(string)) {
                return this.left;
            }
        }
        return null;
    }

    Expression getAdditional(Session session, Comparison comparison, boolean bl) {
        if (this.compareType == comparison.compareType && this.compareType == 0) {
            boolean bl2 = this.left.isConstant();
            boolean bl3 = this.right.isConstant();
            boolean bl4 = comparison.left.isConstant();
            boolean bl5 = comparison.right.isConstant();
            String string = this.left.getSQL(true);
            String string2 = comparison.left.getSQL(true);
            String string3 = this.right.getSQL(true);
            String string4 = comparison.right.getSQL(true);
            if (bl) {
                if (!(bl3 && bl5 || !string.equals(string2))) {
                    return new Comparison(session, 0, this.right, comparison.right);
                }
                if (!(bl3 && bl4 || !string.equals(string4))) {
                    return new Comparison(session, 0, this.right, comparison.left);
                }
                if (!(bl2 && bl5 || !string3.equals(string2))) {
                    return new Comparison(session, 0, this.left, comparison.right);
                }
                if (!(bl2 && bl4 || !string3.equals(string4))) {
                    return new Comparison(session, 0, this.left, comparison.left);
                }
            } else {
                if (bl3 && bl5 && string.equals(string2)) {
                    return Comparison.getConditionIn(session, this.left, this.right, comparison.right);
                }
                if (bl3 && bl4 && string.equals(string4)) {
                    return Comparison.getConditionIn(session, this.left, this.right, comparison.left);
                }
                if (bl2 && bl5 && string3.equals(string2)) {
                    return Comparison.getConditionIn(session, this.right, this.left, comparison.right);
                }
                if (bl2 && bl4 && string3.equals(string4)) {
                    return Comparison.getConditionIn(session, this.right, this.left, comparison.left);
                }
            }
        }
        return null;
    }

    private static ConditionIn getConditionIn(Session session, Expression expression, Expression expression2, Expression expression3) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
        arrayList.add(expression2);
        arrayList.add(expression3);
        return new ConditionIn(session.getDatabase(), expression, arrayList);
    }

    @Override
    public int getSubexpressionCount() {
        return this.compareType == 6 || this.compareType == 7 ? 1 : 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                if (this.compareType == 6 || this.compareType == 7) break;
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

